
#This has to do with the following bioassays
# Onion - Phoma                               # oni1
# Spinach - Fusarium                          # spi2
# Pepper - Phytophthora capsici               # pep  / pepper
# Red fescue - Laetisaria fuciformis          # fes
# Perennial ryegrass - Laetisaria fuciformis  # per1
# Perennial ryegrass - Puccinia               # per2

# Import data -------------------------------------------------------------
#setwd()
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2
all_data$LotCode <- paste(all_data$SeedLot, '_', all_data$BioassayType)

onion2 <- read.csv('OnionPhoma_4Rdata.csv')
onion2$LeafScore <- onion2$LeafScore1to5 *2
#changing the leaf symptoms scale from 1 to 5 and making it 1 to 10
#because during data collection 0.5 scores were given (2.5, 3.5 etc.)
onion2$RootScore <- onion2$RootScore1to5
#not necessary for the root symptoms 

spinach2 <- read.csv('SpinachFusarium_4Rdata.csv')

pepper <- read.csv("Pepper_plant_4Rdata.csv")
pepper <- na.omit(pepper)

fescue_thread <- read.csv('Red_fescue_4Rdata.csv')
perennial_thread <- read.csv('Perennial_thread_4Rdata.csv')
perennial_puccinia <- read.csv("Perennial_puccinia_4Rdata.csv") 

# Reverse directionality for: onion2, spinach2, pepper -----------------------------
#this way in all sub figures, high levels of infection will be at the top
onion2$LeafScore.rev <- -(onion2$LeafScore)+11
onion2$RootScore.rev <- -(onion2$RootScore)+5

spinach2$Fus322.rev <- -(spinach2$Fus322)+11
spinach2$Fus254.rev <- -(spinach2$Fus254)+11

pepper$Evaluation1.rev <- -(pepper$Evaluation1)+10
pepper$Evaluation2.rev <- -(pepper$Evaluation2)+10

# Packages ----------------------------------------------------------------
# library(ggplot2)
# library(tidyverse)
# library(ggpubr)
# library(ggrepel)
# 
library(gridExtra)
library(cowplot)
library(ggtext)
library(ggstance)
library(ggExtra)
library(grid)
# 
library(plyr) #ddply for medians

# Onion - Phoma  data prep -----------------------------------------------------------------------

onion2$LotCode <- paste(onion2$SeedLot, '_', 'Onion_Phoma')  
onion2$var1 <- all_data$Bio_var1[match(onion2$LotCode, all_data$LotCode)]
onion2$var2 <- all_data$Bio_var2[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_en <- all_data$Ger_energy[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_cap <- all_data$Ger_capacity[match(onion2$LotCode, all_data$LotCode)]
onion2<-onion2[!(onion2$reject_en=="affected" | onion2$reject_cap=="affected"),]

head(onion2)
onion2$SeedLot <- as.character(onion2$SeedLot)

onion2Med <- ddply(onion2, c('MRTrt', 'SeedLot'), summarise,
                   median.LeafScore = median(LeafScore.rev),
                   median.RootScore = median(RootScore.rev))

onion2_untrt <- onion2Med[onion2Med$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
onion2_trt <- onion2Med[onion2Med$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
onion2_sep <- cbind(onion2_untrt, onion2_trt)
onion2 <- onion2_sep

onion2$SeedLot <- onion2$SeedLot_untrt
onion2$LotCode <- paste(onion2$SeedLot, '_', 'Onion_Phoma')  
onion2$var1 <- all_data$Bio_var1[match(onion2$LotCode, all_data$LotCode)]
onion2$var2 <- all_data$Bio_var2[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_en <- all_data$Ger_energy[match(onion2$LotCode, all_data$LotCode)]
onion2$reject_cap <- all_data$Ger_capacity[match(onion2$LotCode, all_data$LotCode)]
onion2<-onion2[!(onion2$reject_en=="affected" | onion2$reject_cap=="affected"),]

# Onion - Phoma  variable 2 -----------------------------------------------------------------------

on2 <- ggplot(onion2, aes(x=median.LeafScore_untrt, y=median.LeafScore_trt, 
                         colour=var2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(0.9,10)) +
  scale_x_continuous(breaks=c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(0.9,10)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(1, 10), xlim = c(1,10)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="B2. Onion -"~italic(S.)~~italic(terrestris)~" ",
       subtitle = "Leaf symptoms",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Onion - Phoma  variable 1  -------------------------------------------------------------------
on1 <- ggplot(onion2, aes(x=median.RootScore_untrt, y=median.RootScore_trt, 
                          colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0,5.3)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0,5.3)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 5.2), xlim = c(0,5.2)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="B1. Onion -"~italic(S.)~~italic(terrestris)~" ",
       subtitle = "Root symptoms",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

#
#
#
#
#
#


# Spinach - Fusarium  data prep -----------------------------------------------------------------------

spinach2$LotCode <- paste(spinach2$SeedLot, '_', 'Spinach_Fusarium')  
spinach2$var1 <- all_data$Bio_var1[match(spinach2$LotCode, all_data$LotCode)]
spinach2$var2 <- all_data$Bio_var2[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_en <- all_data$Ger_energy[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_cap <- all_data$Ger_capacity[match(spinach2$LotCode, all_data$LotCode)]
spinach2<-spinach2[!(spinach2$reject_en=="affected" | spinach2$reject_cap=="affected"),]

head(spinach2)
spinach2$SeedLot <- as.character(spinach2$SeedLot)

spinach2Med <- ddply(spinach2, c('MRTrt', 'SeedLot'), summarise,
                     median.Fus322 = median(Fus322.rev),
                     median.Fus254 = median(Fus254.rev))

spinach2_untrt <- spinach2Med[spinach2Med$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
spinach2_trt <- spinach2Med[spinach2Med$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
spinach2_sep <- cbind(spinach2_untrt, spinach2_trt)
spinach2 <- spinach2_sep

spinach2$SeedLot <- spinach2$SeedLot_untrt
spinach2$LotCode <- paste(spinach2$SeedLot, '_', 'Spinach_Fusarium')  
spinach2$var1 <- all_data$Bio_var1[match(spinach2$LotCode, all_data$LotCode)]
spinach2$var2 <- all_data$Bio_var2[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_en <- all_data$Ger_energy[match(spinach2$LotCode, all_data$LotCode)]
spinach2$reject_cap <- all_data$Ger_capacity[match(spinach2$LotCode, all_data$LotCode)]
spinach2<-spinach2[!(spinach2$reject_en=="affected" | spinach2$reject_cap=="affected"),]
# Spinach - Fusarium  variable 1 -----------------------------------------------------------------------

sp1 <- ggplot(spinach2, aes(x=median.Fus322_untrt, y=median.Fus322_trt, 
                          colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(-0,10)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(-0,10)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 10), xlim = c(0,10)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="E1. Spinach -"~italic(F.)~~italic(oxysporum)~" ",
       subtitle = "Fus322 infection",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Spinach - Fusarium  variable 2  -------------------------------------------------------------------
sp2 <- ggplot(spinach2, aes(x=median.Fus254_untrt, y=median.Fus254_trt, 
                          colour=var2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(-0,10)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), limits=c(-0,10)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 10), xlim = c(0,10)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="E2. Spinach -"~italic(F.)~~italic(oxysporum)~" ",
       subtitle = "Fus254 infection",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")
#
#
#
#
#
#
# Pepper - Phytophthora capsici  data prep -----------------------------------------------------------------------

pepper$LotCode <- paste(pepper$SeedLot, '_', 'Pepper plants_Phytophthora capsici')  
pepper$var1 <- all_data$Bio_var1[match(pepper$LotCode, all_data$LotCode)]
pepper$var2 <- all_data$Bio_var2[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_en <- all_data$Ger_energy[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_cap <- all_data$Ger_capacity[match(pepper$LotCode, all_data$LotCode)]
pepper<-pepper[!(pepper$reject_en=="affected" | pepper$reject_cap=="affected"),]

head(pepper)
pepper$SeedLot <- as.character(pepper$SeedLot)

pepperMed <- ddply(pepper, c('MRTrt', 'SeedLot'), summarise,
                     median.Evaluation1 = median(Evaluation1.rev),
                     median.Evaluation2 = median(Evaluation2.rev))

pepperMed$MRTrt[which(pepperMed$MRTrt == 'untreated')] <- 'untrt'
pepperMed$MRTrt[which(pepperMed$MRTrt == 'treated')] <- 'trt'

pepper_untrt <- pepperMed[pepperMed$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
pepper_trt <- pepperMed[pepperMed$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
pepper_sep <- cbind(pepper_untrt, pepper_trt)
pepper <- pepper_sep

pepper$SeedLot <- pepper$SeedLot_untrt
pepper$LotCode <- paste(pepper$SeedLot, '_', 'Pepper plants_Phytophthora capsici')  
pepper$var1 <- all_data$Bio_var1[match(pepper$LotCode, all_data$LotCode)]
pepper$var2 <- all_data$Bio_var2[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_en <- all_data$Ger_energy[match(pepper$LotCode, all_data$LotCode)]
pepper$reject_cap <- all_data$Ger_capacity[match(pepper$LotCode, all_data$LotCode)]
pepper<-pepper[!(pepper$reject_en=="affected" | pepper$reject_cap=="affected"),]
# Pepper - Phytophthora capsici  variable 1 -----------------------------------------------------------------------

pe1 <- ggplot(pepper, aes(x=median.Evaluation1_untrt, y=median.Evaluation1_trt, 
                            colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.3, h = 0.3)) +
  scale_y_continuous(breaks=c(1, 5, 9), limits=c(0.5,9.5)) +
  scale_x_continuous(breaks=c(1, 5, 9), limits=c(0.5,9.5)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 10), xlim = c(0, 10)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="G1. Pepper plants -"~italic(P.)~~italic(capsici)~" ",
       subtitle = "Disease 7 dpo",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Pepper - Phytophthora capsici  variable 2  -------------------------------------------------------------------
pe2 <- ggplot(pepper, aes(x=median.Evaluation2_untrt, y=median.Evaluation2_trt, 
                          colour=var2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6,
             size = 2, stroke = 1, 
             position = position_jitter(w = 0.3, h = 0.3)) +
  scale_y_continuous(breaks=c(1, 5, 9), limits=c(0.5,9.5)) +
  scale_x_continuous(breaks=c(1, 5, 9), limits=c(0.5,9.5)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 10), xlim = c(0, 10)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="G2. Pepper plants -"~italic(P.)~~italic(capsici)~" ",
       subtitle = "Disease 14 dpo",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")


#
#
#
#
#
#
# Red fescue - red thread data prep -----------------------------------------------------------------------
head(fescue_thread)

fescue_thread$LotCode <- paste(fescue_thread$SeedLot, '_', 'Red fescue_Laetisaria fuciformis')  
fescue_thread$var1 <- all_data$Bio_var1[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread$reject_en <- all_data$Ger_energy[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread$reject_cap <- all_data$Ger_capacity[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread<-fescue_thread[!(fescue_thread$reject_en=="affected" | fescue_thread$reject_cap=="affected"),]

head(fescue_thread)
fescue_thread$SeedLot <- as.character(fescue_thread$SeedLot)

fescue_threadMed <- ddply(fescue_thread, c('MRTrt', 'SeedLot'), summarise,
                             median.Disease = median(Disease))

fescue_threadMed$MRTrt[which(fescue_threadMed$MRTrt == 'untreated')] <- 'untrt'
fescue_threadMed$MRTrt[which(fescue_threadMed$MRTrt == 'treated')] <- 'trt'

fescue_thread_untrt <- fescue_threadMed[fescue_threadMed$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
fescue_thread_trt <- fescue_threadMed[fescue_threadMed$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
fescue_thread_sep <- cbind(fescue_thread_untrt, fescue_thread_trt)
fescue_thread <- fescue_thread_sep

fescue_thread$SeedLot <- fescue_thread$SeedLot_untrt
fescue_thread$LotCode <- paste(fescue_thread$SeedLot, '_', 'Red fescue_Laetisaria fuciformis')  
fescue_thread$var1 <- all_data$Bio_var1[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread$reject_en <- all_data$Ger_energy[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread$reject_cap <- all_data$Ger_capacity[match(fescue_thread$LotCode, all_data$LotCode)]
fescue_thread<-fescue_thread[!(fescue_thread$reject_en=="affected" | fescue_thread$reject_cap=="affected"),]

# Red fescue - red thread variable 1 -----------------------------------------------------------------------

fes1 <- ggplot(fescue_thread, aes(x=median.Disease_untrt, y=median.Disease_trt, 
                                       colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 5), xlim = c(0, 5)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="I. Red fescue -"~italic(L.)~~italic(fuciformis)~" ",
       subtitle = "Leaf symptoms",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Perennial ryegrass - red thread data prep -----------------------------------------------------------------------
head(perennial_thread)

perennial_thread$LotCode <- paste(perennial_thread$SeedLot, '_', 'Perennial ryegrass_Laetisaria fuciformis')  
perennial_thread$var1 <- all_data$Bio_var1[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread$reject_en <- all_data$Ger_energy[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread$reject_cap <- all_data$Ger_capacity[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread<-perennial_thread[!(perennial_thread$reject_en=="affected" | perennial_thread$reject_cap=="affected"),]

head(perennial_thread)
perennial_thread$SeedLot <- as.character(perennial_thread$SeedLot)

perennial_threadMed <- ddply(perennial_thread, c('MRTrt', 'SeedLot'), summarise,
                               median.Disease = median(Disease))

perennial_threadMed$MRTrt[which(perennial_threadMed$MRTrt == 'untreated')] <- 'untrt'
perennial_threadMed$MRTrt[which(perennial_threadMed$MRTrt == 'treated')] <- 'trt'

perennial_thread_untrt <- perennial_threadMed[perennial_threadMed$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
perennial_thread_trt <- perennial_threadMed[perennial_threadMed$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
perennial_thread_sep <- cbind(perennial_thread_untrt, perennial_thread_trt)
perennial_thread <- perennial_thread_sep

perennial_thread$SeedLot <- perennial_thread$SeedLot_untrt
perennial_thread$LotCode <- paste(perennial_thread$SeedLot, '_', 'Perennial ryegrass_Laetisaria fuciformis')  
perennial_thread$var1 <- all_data$Bio_var1[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread$reject_en <- all_data$Ger_energy[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread$reject_cap <- all_data$Ger_capacity[match(perennial_thread$LotCode, all_data$LotCode)]
perennial_thread<-perennial_thread[!(perennial_thread$reject_en=="affected" | perennial_thread$reject_cap=="affected"),]

# Perennial ryegrass - red thread variable 1 -----------------------------------------------------------------------
perth1 <- ggplot(perennial_thread, aes(x=median.Disease_untrt, y=median.Disease_trt, 
                                         colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 5), xlim = c(0, 5)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="J. Ryegrass -"~italic(L.)~~italic(fuciformis)~" ",
       subtitle = "Leaf symptoms",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Perennial ryegrass - Puccinia data prep -----------------------------------------------------------------------
head(perennial_puccinia)

perennial_puccinia$LotCode <- paste(perennial_puccinia$SeedLot, '_', 'Perennial ryegrass_Puccinia sp.')  
perennial_puccinia$var1 <- all_data$Bio_var1[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia$reject_en <- all_data$Ger_energy[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia$reject_cap <- all_data$Ger_capacity[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia<-perennial_puccinia[!(perennial_puccinia$reject_en=="affected" | perennial_puccinia$reject_cap=="affected"),]

head(perennial_puccinia)
perennial_puccinia$SeedLot <- as.character(perennial_puccinia$SeedLot)

perennial_pucciniaMed <- ddply(perennial_puccinia, c('MRTrt', 'SeedLot'), summarise,
                   median.Disease = median(Disease))

perennial_pucciniaMed$MRTrt[which(perennial_pucciniaMed$MRTrt == 'untreated')] <- 'untrt'
perennial_pucciniaMed$MRTrt[which(perennial_pucciniaMed$MRTrt == 'treated')] <- 'trt'

perennial_puccinia_untrt <- perennial_pucciniaMed[perennial_pucciniaMed$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
perennial_puccinia_trt <- perennial_pucciniaMed[perennial_pucciniaMed$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
perennial_puccinia_sep <- cbind(perennial_puccinia_untrt, perennial_puccinia_trt)
perennial_puccinia <- perennial_puccinia_sep

perennial_puccinia$SeedLot <- perennial_puccinia$SeedLot_untrt
perennial_puccinia$LotCode <- paste(perennial_puccinia$SeedLot, '_', 'Perennial ryegrass_Puccinia sp.')  
perennial_puccinia$var1 <- all_data$Bio_var1[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia$reject_en <- all_data$Ger_energy[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia$reject_cap <- all_data$Ger_capacity[match(perennial_puccinia$LotCode, all_data$LotCode)]
perennial_puccinia<-perennial_puccinia[!(perennial_puccinia$reject_en=="affected" | perennial_puccinia$reject_cap=="affected"),]

# Perennial ryegrass - Puccinia variable 1 -----------------------------------------------------------------------
perpu1 <- ggplot(perennial_puccinia, aes(x=median.Disease_untrt, y=median.Disease_trt, 
                          colour=var1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1, 
             position = position_jitter(w = 0.1, h = 0.1)) +
  scale_y_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_x_continuous(breaks=c(0, 1, 2, 3, 4, 5), limits=c(0, 5.8)) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 5), xlim = c(0, 5)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="K. Ryegrass -"~italic(Puccinia)~" sp.",
       subtitle = "Leaf symptoms",
       y="Disinfected seeds (median)", 
       x="Non-treated seeds (median)")

# Legend -------------------------------------------------------------------
forLeg <- ggplot(perennial_puccinia, aes(x=median.Disease_untrt, y=median.Disease_trt, 
                                                   colour=var1)) + 
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"),
                     labels = c('Positively responsive seed lots',
                                 'Non-responsive seed lots', 
                                 'Negatively responsive seed lots')) + 
  theme_bw() + theme_classic() + 
  theme(legend.position=c(0.5,0.5), legend.title = element_blank(),
        legend.text = element_text(size=11))
  
legend <- get_legend(forLeg)
